
<?php $total=0;?>
<!DOCTYPE html>
<html lang="<?php _trans('cldr'); ?>">
<head>
    <meta charset="utf-8">
    <title><?php _trans('Expense'); ?></title>
    <link rel="stylesheet"
          href="<?php echo base_url(); ?>assets/<?php echo get_setting('system_theme', 'invoiceplane'); ?>/css/templates.css">
    <link rel="stylesheet" href="<?php echo base_url(); ?>assets/core/css/custom-pdf.css">
</head>
<body>
<header class="clearfix">

    <div id="logo">
        <?php echo invoice_logo_pdf(); ?>
    </div>

    <div id="company">
    <?php foreach ($company as $invoice) :?>
        <div><b><?php _htmlsc($invoice->user_company); ?></b></div>
        <?php if ($invoice->user_vat_id) {
            echo '<div>' . trans('vat_id_short') . ': ' . $invoice->user_vat_id . '</div>';
        }
        if ($invoice->user_tax_code) {
            echo '<div>' . trans('tax_code_short') . ': ' . $invoice->user_tax_code . '</div>';
        }
        if ($invoice->user_address_1) {
            echo '<div>' . htmlsc($invoice->user_address_1) . '</div>';
        }
        if ($invoice->user_address_2) {
            echo '<div>' . htmlsc($invoice->user_address_2) . '</div>';
        }
        if ($invoice->user_city || $invoice->user_state || $invoice->user_zip) {
            echo '<div>';
            if ($invoice->user_city) {
                echo htmlsc($invoice->user_city) . ' ';
            }
            if ($invoice->user_state) {
                echo htmlsc($invoice->user_state) . ' ';
            }
            if ($invoice->user_zip) {
                echo htmlsc($invoice->user_zip);
            }
            echo '</div>';
        }
        if ($invoice->user_country) {
            echo '<div>' . get_country_name(trans('cldr'), $invoice->user_country) . '</div>';
        }

        echo '<br/>';

        ?>
        <?php endforeach; ?>

        <?php
        foreach ($expenses as $expense){

            if ($expense['expense_name']) {
                echo '<div><b>' . trans('Expense Name:') . ': ' . htmlsc($expense['expense_name']) . '<b></div>';
            }
            if ($expense['expense_date_created']) {
                echo '<div><b>' . trans('Expense Date:') . ': ' . htmlsc($expense['expense_date_created']) . '<b></div>';
            }
            
            echo '<div><b>'  . htmlsc($expense['expense_status']==1 ? 'Expense Status:: Paid' : 'Expense Status:: Draft') . '</b></div>';
            
        }
            ?>
        


    </div>
</header>



    <h1 class="invoice-title"><?php echo trans('Expense') . ' ' . $expense['expense_id']; ?></h1>

    <table class="item-table">
        <thead>
        <tr>
            <th class="text-right"><?php _trans('item'); ?></th>
            <th class="text-right"><?php _trans('description'); ?></th>
            <th class="text-right"><?php _trans('qty'); ?></th>
            <th class="text-right"><?php _trans('Amount'); ?></th>
            <th class="text-right"><?php _trans('total'); ?></th>
        </tr>
        </thead>
        <tbody>

        <?php  
        foreach ($items as $item) {
            $total += $item['item_total'];
            ?>
            <tr>
                <td class="text-right"><?php echo ($item['item_name']); ?></td>
                <td class="text-right"><?php echo ($item['item_description']); ?></td>
                <td class="text-right"><?php echo($item['item_quantity']); ?></td>
                <td class="text-right"><?php echo format_currency($item['item_price']); ?></td>
                <td class="text-right"><?php echo format_currency($item['item_total']); ?></td>
            </tr>
            <tr>
                <td class="text-right" colspan="4"><b><?php _trans('total'); ?></b></td>
            <td class="text-right"><?php echo format_currency($total); ?></td>
            </tr>

            <?php } ?>
        </tbody>


    </table>

</main>
<footer>
<?php 
foreach($company as $invoice){
if ($invoice->user_name) : ?>
        <div class="notes">
            <b><?php _trans('Created By: '); ?>
            <?php echo nl2br(htmlsc($invoice->user_name)); ?>
        </div>
    <?php endif; }?>
    </footer>
</body>
</html>
